<?php
header("Content-Type: application/json");
include "db.php"; // your database connection

$id = $_POST['id'] ?? null;

if (!$id) {
  echo json_encode(["success" => false, "message" => "No ID provided"]);
  exit;
}

// Make sure the ID is numeric (optional safety)
$id = intval($id);

// Prepare and execute delete query
$stmt = $conn->prepare("DELETE FROM services WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();

// Check if anything was actually deleted
if ($stmt->affected_rows > 0) {
  echo json_encode(["success" => true, "message" => "Service deleted successfully!"]);
} else {
  echo json_encode(["success" => false, "message" => "No record found for this ID."]);
}

$stmt->close();
$conn->close();
?>
