<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

$response = ["success" => false, "message" => "Unknown error"];

$uploadDir = __DIR__ . "/uploads/"; // Save images to /api/uploads/
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

if (!empty($_FILES['image']['name'])) {
    $fileName = time() . "_" . basename($_FILES["image"]["name"]);
    $targetFile = $uploadDir . $fileName;

    // Validate file type
    $allowedTypes = ["jpg", "jpeg", "png", "gif", "webp"];
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if (!in_array($fileExt, $allowedTypes)) {
        echo json_encode([
            "success" => false,
            "message" => "Invalid file type. Only JPG, PNG, GIF, WEBP allowed."
        ]);
        exit;
    }

    // Move uploaded file
    if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFile)) {
        // Relative path to use in React
        $relativePath = "uploads/" . $fileName;
        echo json_encode([
            "success" => true,
            "message" => "Image uploaded successfully.",
            "filePath" => $relativePath
        ]);
        exit;
    } else {
        $response["message"] = "Failed to move uploaded file.";
    }
} else {
    $response["message"] = "No image received.";
}

echo json_encode($response);
